local enums = require("consts.celeste_enums")
local drawableSprite = require("structs.drawable_sprite")

local needle = {}

local versionCheck = require("mods").requireFromPlugin("libraries.MoreLoennPlugins.versionCheck")
if not versionCheck.validModVersion("Needle Helper", "1.0.0")
  then return {}
end
needle.associatedMods = { "NeedleHelper" }

needle.name = "Needle Helper/IWBTGNeedle"
needle.depth = 0
needle.texture = "objects/NeedleHelper/NeedleUp/needle00"
needle.placements = {
    {
        name = "needleUp",
        data = {
            direction = "Up",
            directory = "objects/NeedleHelper"
        }
    },
    {
        name = "needleDown",
        data = {
            direction = "Down",
            directory = "objects/NeedleHelper"
        }
    },
    {
        name = "needleLeft",
        data = {
            direction = "Left",
            directory = "objects/NeedleHelper"
        }
    },
    {
        name = "needleRight",
        data = {
            direction = "Right",
            directory = "objects/NeedleHelper"
        }
    }
}

function needle.sprite(room, entity)
    return drawableSprite.fromTexture(entity.directory .. "/Needle" .. entity.direction .. "/needle00" , entity)
end

needle.fieldInformation = {
    direction = {
        options = enums.dash_switch_sides,
        editable = false
    }
}

needle.fieldOrder = {
    "x", "y",
    "direction", "directory"
}

return needle